/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.Version;
import org.python.core.CodeFlag;
import org.python.core.CompileMode;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.core.util.RelativeFile;
import org.python.modules._systemrestart;
import org.python.modules.posix.PosixModule;
import org.python.modules.thread.thread;
import org.python.util.CommandLineOptions;
import org.python.util.InteractiveConsole;
import org.python.util.JLineConsole;

public class jython {
    private static final String COPYRIGHT = "Type \"help\", \"copyright\", \"credits\" or \"license\" for more information.";
    static final String usageHeader = "usage: jython [option] ... [-c cmd | -m mod | file | -] [arg] ...\n";
    private static final String usage = "usage: jython [option] ... [-c cmd | -m mod | file | -] [arg] ...\nOptions and arguments:\n-c cmd   : program passed in as string (terminates option list)\n-Dprop=v : Set the property `prop' to value `v'\n-C codec : Use a different codec when reading from the console.\n-h       : print this help message and exit (also --help)\n-i       : inspect interactively after running script\n           and force prompts, even if stdin does not appear to be a terminal\n-jar jar : program read from __run__.py in jar file\n-m mod   : run library module as a script (terminates option list)\n-Q arg   : division options: -Qold (default), -Qwarn, -Qwarnall, -Qnew\n-S       : don't imply 'import site' on initialization\n-u       : unbuffered binary stdout and stderr\n-v       : verbose (trace import statements)\n-V       : print the Python version number and exit (also --version)\n-W arg   : warning control (arg is action:message:category:module:lineno)\nfile     : program read from script file\n-        : program read from stdin (default; interactive mode if a tty)\narg ...  : arguments passed to program in sys.argv[1:]\nOther environment variables:\nJYTHONPATH: '" + File.pathSeparator + "'-separated list of directories prefixed to the default module\n" + "            search path.  The result is sys.path.";
    public static boolean shouldRestart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runJar(String string) {
        try {
            PyCode pyCode;
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry("__run__.py");
            if (zipEntry == null) {
                throw Py.ValueError("jar file missing '__run__.py'");
            }
            PyStringMap pyStringMap = Py.newStringMap();
            int n = string.lastIndexOf(File.separator);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            pyStringMap.__setitem__("__name__", (PyObject)new PyString(string));
            pyStringMap.__setitem__("zipfile", Py.java2py(zipFile));
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                pyCode = Py.compile(inputStream, "__run__", CompileMode.exec);
            }
            finally {
                inputStream.close();
            }
            Py.runCode(pyCode, pyStringMap, pyStringMap);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public static void main(String[] stringArray) {
        do {
            shouldRestart = false;
            jython.run(stringArray);
        } while (shouldRestart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String[] stringArray) {
        InteractiveConsole interactiveConsole;
        CommandLineOptions commandLineOptions;
        block54: {
            commandLineOptions = new CommandLineOptions();
            if (!commandLineOptions.parse(stringArray)) {
                if (commandLineOptions.version) {
                    System.err.println("Jython " + Version.PY_VERSION);
                    System.exit(0);
                }
                if (!commandLineOptions.runCommand && !commandLineOptions.runModule) {
                    System.err.println(usage);
                }
                int n = commandLineOptions.help ? 0 : -1;
                System.exit(n);
            }
            PySystemState.initialize(PySystemState.getBaseProperties(), commandLineOptions.properties, commandLineOptions.argv);
            PyList pyList = new PyList();
            for (String object2 : commandLineOptions.warnoptions) {
                pyList.append(new PyString(object2));
            }
            Py.getSystemState().setWarnoptions(pyList);
            PySystemState pySystemState = Py.getSystemState();
            if (!commandLineOptions.fixInteractive || commandLineOptions.interactive) {
                commandLineOptions.interactive = ((PyFile)Py.defaultSystemState.stdin).isatty();
                if (!commandLineOptions.interactive) {
                    pySystemState.ps1 = pySystemState.ps2 = Py.EmptyString;
                }
            }
            interactiveConsole = jython.newInterpreter(commandLineOptions.interactive);
            pySystemState.__setattr__("_jy_interpreter", Py.java2py(interactiveConsole));
            if (commandLineOptions.interactive && commandLineOptions.notice && !commandLineOptions.runModule) {
                System.err.println(InteractiveConsole.getDefaultBanner());
            }
            if (Options.importSite) {
                try {
                    imp.load("site");
                    if (commandLineOptions.interactive && commandLineOptions.notice && !commandLineOptions.runModule) {
                        System.err.println(COPYRIGHT);
                    }
                }
                catch (PyException string) {
                    if (string.match(Py.ImportError)) break block54;
                    System.err.println("error importing site");
                    Py.printException(string);
                    System.exit(-1);
                }
            }
        }
        if (commandLineOptions.division != null) {
            if ("old".equals(commandLineOptions.division)) {
                Options.divisionWarning = 0;
            } else if ("warn".equals(commandLineOptions.division)) {
                Options.divisionWarning = 1;
            } else if ("warnall".equals(commandLineOptions.division)) {
                Options.divisionWarning = 2;
            } else if ("new".equals(commandLineOptions.division)) {
                Options.Qnew = true;
                interactiveConsole.cflags.setFlag(CodeFlag.CO_FUTURE_DIVISION);
            }
        }
        if (commandLineOptions.filename != null) {
            String throwable;
            try {
                throwable = new File(commandLineOptions.filename).getCanonicalFile().getParent();
            }
            catch (IOException throwable2) {
                throwable = new File(commandLineOptions.filename).getAbsoluteFile().getParent();
            }
            if (throwable == null) {
                throwable = "";
            }
            Py.getSystemState().path.insert(0, new PyString(throwable));
            if (commandLineOptions.jar) {
                try {
                    jython.runJar(commandLineOptions.filename);
                }
                catch (Throwable throwable3) {
                    Py.printException(throwable3);
                    System.exit(-1);
                }
            } else if (commandLineOptions.filename.equals("-")) {
                try {
                    interactiveConsole.globals.__setitem__(new PyString("__file__"), (PyObject)new PyString("<stdin>"));
                    interactiveConsole.execfile(System.in, "<stdin>");
                }
                catch (Throwable fileInputStream) {
                    Py.printException(fileInputStream);
                }
            } else {
                try {
                    FileInputStream throwable4;
                    interactiveConsole.globals.__setitem__(new PyString("__file__"), (PyObject)new PyString(commandLineOptions.filename));
                    try {
                        throwable4 = new FileInputStream(new RelativeFile(commandLineOptions.filename));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw Py.IOError(fileNotFoundException);
                    }
                    try {
                        if (PosixModule.getPOSIX().isatty(throwable4.getFD())) {
                            commandLineOptions.interactive = true;
                            interactiveConsole.interact(null, new PyFile(throwable4));
                            return;
                        }
                        interactiveConsole.execfile(throwable4, commandLineOptions.filename);
                    }
                    finally {
                        throwable4.close();
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable5 instanceof PyException && ((PyException)throwable5).match(_systemrestart.SystemRestart)) {
                        shouldRestart = true;
                        jython.shutdownInterpreter();
                        interactiveConsole.cleanup();
                        Py.setSystemState(new PySystemState());
                        return;
                    }
                    Py.printException(throwable5);
                    interactiveConsole.cleanup();
                    System.exit(-1);
                }
            }
        } else {
            Py.getSystemState().path.insert(0, Py.EmptyString);
            if (commandLineOptions.command != null) {
                try {
                    interactiveConsole.exec(commandLineOptions.command);
                }
                catch (Throwable throwable) {
                    Py.printException(throwable);
                    System.exit(1);
                }
            }
            if (commandLineOptions.moduleName != null) {
                try {
                    interactiveConsole.exec("import runpy");
                    interactiveConsole.set("name", Py.newString(commandLineOptions.moduleName));
                    interactiveConsole.exec("runpy.run_module(name, run_name='__main__', alter_sys=True)");
                    interactiveConsole.cleanup();
                    return;
                }
                catch (Throwable throwable) {
                    Py.printException(throwable);
                    interactiveConsole.cleanup();
                    System.exit(-1);
                }
            }
        }
        if (commandLineOptions.fixInteractive || commandLineOptions.filename == null && commandLineOptions.command == null) {
            if (commandLineOptions.encoding == null) {
                commandLineOptions.encoding = PySystemState.registry.getProperty("python.console.encoding");
            }
            if (commandLineOptions.encoding != null) {
                if (!Charset.isSupported(commandLineOptions.encoding)) {
                    System.err.println(commandLineOptions.encoding + " is not a supported encoding on this JVM, so it can't " + "be used in python.console.encoding.");
                    System.exit(1);
                }
                interactiveConsole.cflags.encoding = commandLineOptions.encoding;
            }
            try {
                interactiveConsole.interact(null, null);
            }
            catch (Throwable throwable) {
                Py.printException(throwable);
            }
        }
        interactiveConsole.cleanup();
    }

    private static InteractiveConsole newInterpreter(boolean bl) {
        if (!bl) {
            return new InteractiveConsole();
        }
        String string = PySystemState.registry.getProperty("python.console", "");
        if (string.length() > 0) {
            try {
                return (InteractiveConsole)Class.forName(string).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new JLineConsole();
    }

    public static void shutdownInterpreter() {
        thread.interruptAllThreads();
        Py.getSystemState()._systemRestart = true;
        try {
            imp.load("socket").__findattr__("_closeActiveSockets").__call__();
        }
        catch (PyException pyException) {
            // empty catch block
        }
    }
}

